/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('paypal_sdk', () => {
  return {
    init: (config) => {
      let params = config.PayPalSDKParams ?? 'client-id=sb&currency=USD&components=buttons,funding-eligibility,messages';
      let sdkUrl = 'https://www.paypal.com/sdk/js?' + params;
      let script = document.createElement('script');
      let container = document.body || document.head;

      script.setAttribute('src', sdkUrl);
      script.setAttribute('async', true);
      script.onload = function () {
        xcart.trigger('paypal_sdk.loaded');
      };

      container.append(script);
    }
  }
});

define('paypal_button_preview', ['paypal_sdk', 'js/underscore'], (sdk, _) => {
  return {
    observed: {
      'size': '.select-buttonsize select',
      'color': '.select-buttoncolor select',
      'shape': '.select-buttonshape select'
    },
    getData: function (element) {
      let result = {};
      let line = element.hasClass('.line') ? element : element.closest('.line');

      _.each(this.observed, function(selector, attr){
        if (!result[attr]) result[attr] = line.find(selector).val();
      });

      _.extend(result, {
        layout: 'vertical',
        label: 'paypal',
        tagline: false,
        height: 40
      });

      return result;
    },
    init: function (line) {
      let $container = line.find('.preview-container');
      let id = $container.attr('id') ?? $container.attr('id', 'preview-container-' + _.random(1000)).attr('id');
      let data = this.getData(line);

      $container
        .empty()
        .removeClass(function (id, css) {
          return (css.match(/(^|\s)pp-\S+/g) || []).join(' ');
        }).addClass('pp-' + data.size);

      paypal.Buttons({
        style: data
      }).render('#' + id);
    }
  }
});

$(document).on('ready', function() {
  require(['paypal_button_preview', 'paypal_sdk'], function (ButtonPreview, PayPalSDK) {
    let commentedData = xcart.getCommentedData($('.button-preview'));
    let config = commentedData.config;

    PayPalSDK.init(config);

    xcart.bind('paypal_sdk.loaded', () => {
      _.each(ButtonPreview.observed, function(selector){
        $(selector).each(function(){
          $(this).on('change', function(){
            let line = $(this).closest('.line');
            setTimeout(function(){
              ButtonPreview.init(line);
            }, 100);
          });
        });
      });

      $('.lines .line').each(function(){
        ButtonPreview.init($(this));
      });
    });
  });
});
