/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

xcart.bind('paypal_sdk.loaded', () => {
  let observed = {
    'data-pp-style-layout': 'ppcm_banner_type',
    'data-pp-style-logo-type': 'ppcm_text_logo_type',
    'data-pp-style-logo-position': 'ppcm_text_logo_position',
    'data-pp-style-text-size': 'ppcm_text_size',
    'data-pp-style-text-color': 'ppcm_text_color',
    'data-pp-style-color': 'ppcm_flex_color_scheme',
    'data-pp-style-ratio': 'ppcm_flex_layout'
  };

  let getData = function () {
    let result = {};

    _.each(observed, function(name, attr){
      let selector = '[name=' + name + ']';
      if ($(selector).closest('li').hasClass('hidden')) return true;
      result[attr] = $(selector).val();
    });

    return result;
  }

  _.each(observed, function(name, attr){
    let selector = '[name=' + name + ']';
    $(selector).on('change', function(){
      setTimeout(function(){
        $('.banner-preview .preview-container').trigger('changeData', getData());
      }, 100);
    });
  });
});
