/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('paypal_sdk', () => {
  return {
    init: (config) => {
      let params = config.PayPalSDKParams ?? 'client-id=sb&currency=USD&components=buttons,funding-eligibility,messages';
      let sdkUrl = 'https://www.paypal.com/sdk/js?' + params;
      let script = document.createElement('script');
      let container = document.body || document.head;

      script.setAttribute('src', sdkUrl);
      script.setAttribute('async', true);
      script.onload = function () {
        xcart.trigger('paypal_sdk.loaded');
      };

      container.append(script);
    }
  }
});

define('paypal_banner_preview', ['paypal_sdk', 'js/underscore'], (sdk, _) => {
  return {
    createPreviewElement: function (attributes) {
      let div = document.createElement('div');
      div.className = 'preview-content';
      _.each(attributes, function(val, key){
        div.setAttribute(key, val);
      });
      return div;
    },
    init: function (selector, attributes) {
      let self = this;
      let $container = $(selector + ' .preview-container');
      let id = $container.attr('id') ?? $container.attr('id', 'preview-container-' + _.random(1000)).attr('id');
      let previewSelector = '#' + id + ' .preview-content';
      let ppData = attributes
        ? $container.prop('ppData', attributes).prop('ppData')
        : $container.prop('ppData');

      $container.empty().append(this.createPreviewElement(ppData));
      paypal.Messages().render(previewSelector);

      /** changing data event */
      $container.on('changeData', function (event, data) {
        let ppData = (typeof data !== 'object')
          ? $(this).prop('ppData')
          : data;

        $(this).off('changeData').prop('ppData', ppData);
        self.init(selector);
      });
    }
  }
});

require(['paypal_banner_preview', 'paypal_sdk'], function (BannerPreview, PayPalSDK) {
  $(document).on('ready', function() {
    let commentedData = xcart.getCommentedData($('.banner-preview'));
    let config = commentedData.config;
    let attributes = commentedData.attributes;

    PayPalSDK.init(config);

    xcart.bind('paypal_sdk.loaded', () => {
      BannerPreview.init('.banner-preview', attributes);
    });
  });
});
