<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\View\StickyPanel;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Info extends \XLite\View\StickyPanel\ItemForm
{
    /**
     * 'Save changes' button of the sticky panel must be visible anyway
     *
     * @return string
     */
    protected function getClass()
    {
        $class = parent::getClass();

        if (
            \XLite\Core\Request::getInstance()->target == 'product'
            && \XLite\Core\Request::getInstance()->page == 'pin_codes'
        ) {
            $class .= ' always-visible';
        }

        return $class;
    }
}
