<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\View\Popup;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class BackstockStatusChangeNotification extends \XLite\View\Popup\BackstockStatusChangeNotification
{
    public function getCSSFiles()
    {
        return array_merge(parent::getCSSFiles(), [
            'modules/CDev/PINCodes/popup/backstock_status_change_notification/style.css',
        ]);
    }

    protected function hasMissingPinCodeItems()
    {
        foreach ($this->getOrder()->getItems() as $item) {
            /* @var OrderItem $item */
            if ($item->countMissingPinCodes()) {
                return true;
            }
        }

        return false;
    }
}
