<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\View\Model;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class InventoryTracking extends \XLite\View\Model\InventoryTracking
{
    /**
     * Disable some element if product has manual pinCodes
     */
    public function __construct()
    {
        if ($this->getModelObject()->hasManualPinCodes()) {
            $this->schemaDefault['inventoryEnabled'][static::SCHEMA_ATTRIBUTES] = [
                'disabled' => 'disabled'
            ];

            $this->schemaDefault['amount'][static::SCHEMA_ATTRIBUTES] = [
                'disabled' => 'disabled'
            ];
            $this->schemaDefault['amount'][self::SCHEMA_HELP] =
                'Quantity in stock is determined by the amount of the remaining PIN codes.';
        }

        parent::__construct();
    }
}
