<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\View\FormModel\Product;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Inventory extends \XLite\View\FormModel\Product\Inventory
{
    /**
     * @return array
     */
    protected function defineFields()
    {
        $schema = parent::defineFields();

        $product = \XLite\Core\Database::getRepo('XLite\Model\Product')->find($this->getDataObject()->default->identity);

        if ($product && $product->hasManualPinCodes()) {
            $schema[self::SECTION_DEFAULT]['inventory_tracking_status']['disabled'] = true;
            $schema[self::SECTION_DEFAULT]['quantity_in_stock']['disabled'] = true;
            $schema[self::SECTION_DEFAULT]['quantity_in_stock']['help'] = static::t('Quantity in stock is determined by the amount of the remaining PIN codes.');
        }

        return $schema;
    }
}
