<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\View\FormField\Inline\Input\Text\Integer;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class ProductQuantity extends \XLite\View\FormField\Inline\Input\Text\Integer\ProductQuantity
{
    /**
     * Register CSS files
     *
     * @return array
     */
    public function getCSSFiles()
    {
        $list = parent::getCSSFiles();

        $list[] = 'modules/CDev/PINCodes/products_list/style.css';

        return $list;
    }

    /**
     * Is editable
     *
     * @return boolean
     */
    public function isEditable()
    {
        return parent::isEditable() && !$this->getEntity()->hasManualPinCodes();
    }

    /**
     * Get view template
     *
     * @return void
     */
    protected function getViewTemplate()
    {
        return $this->getEntity()->hasManualPinCodes()
            ? 'modules/CDev/PINCodes/products_list/product_quantity.twig'
            : 'form_field/inline/input/text/integer/product_quantity.twig';
    }

    /**
     * getPinCodesManagementPageUrl
     *
     * @return string
     */
    protected function getPinCodesManagementPageUrl()
    {
        return $this->buildUrl(
            'product',
            '',
            ['product_id' => $this->getEntity()->getId(), 'page' => 'pin_codes']
        );
    }
}
