<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\Model\Order\Status;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Payment extends \XLite\Model\Order\Status\Payment
{
    /**
     * Return status handlers list
     *
     * @return array
     */
    public static function getStatusHandlers()
    {
        $handlers = parent::getStatusHandlers();

        array_unshift(
            $handlers[static::STATUS_QUEUED][static::STATUS_DECLINED],
            'declinePIN'
        );

        array_unshift(
            $handlers[static::STATUS_QUEUED][static::STATUS_CANCELED],
            'declinePIN'
        );

        return $handlers;
    }
}
