<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\EntityCallback;

use Doctrine\Persistence\Event\LifecycleEventArgs;
use XLite\Model\Product;

final class ProductCallback
{
    public function preRemove(Product $product, LifecycleEventArgs $args): void
    {
        foreach ($product->getPinCodes() as $code) {
            if (!$product->getOrderItem()) {
                $args->getObjectManager()->remove($code);
            }
        }
    }
}
