<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\EntityCallback;

use CDev\PINCodes\Model\PinCode;
use Doctrine\Persistence\Event\LifecycleEventArgs;

final class PinCodeCallback
{
    public function prePersist(PinCode $pinCode, LifecycleEventArgs $args): void
    {
        if (!$pinCode->getCreateDate()) {
            $pinCode->setCreateDate(\XLite\Core\Converter::time());
        }
    }
}
