<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\PINCodes\Core;

use XCart\Event\Service\ViewListMutationEvent;
use XLite;

final class EventListener
{
    public function onCollectViewListMutations(ViewListMutationEvent $event): void
    {
        $event->addMutations([
            'product/inventory/inv_track_amount.twig'   => [
                ViewListMutationEvent::TO_REMOVE => [
                    ['product.inventory.parts', XLite::INTERFACE_WEB, XLite::ZONE_ADMIN],
                ],
            ],
            'product/inventory/inv_track_selector.twig' => [
                ViewListMutationEvent::TO_REMOVE => [
                    ['product.inventory.parts', XLite::INTERFACE_WEB, XLite::ZONE_ADMIN],
                ],
            ],
        ]);
    }
}
