<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\Controller\Admin;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Database;
use XLite\Core\Request;

/**
 * @Extender\Mixin
 */
class Product extends \XLite\Controller\Admin\Product
{
    /**
     * Update pin codes action handler
     *
     * @return void
     */
    public function doActionUpdatePinCodes()
    {
        $product = $this->getProduct();

        $product->setPinCodesEnabled((bool) Request::getInstance()->pins_enabled);
        $product->setAutoPinCodes(Request::getInstance()->autoPinCodes);

        if (Request::getInstance()->delete) {
            foreach (Request::getInstance()->delete as $id => $checked) {
                $obj = Database::getRepo('CDev\PINCodes\Model\PinCode')->findOneBy(
                    [
                        'id'      => $id,
                        'product' => $product->getId(),
                        'isSold'  => 0
                    ]
                );
                if ($obj) {
                    Database::getEM()->remove($obj);
                }
            }
        }

        Database::getEM()->flush($product);
        if ($product->hasManualPinCodes()) {
            $product->setInventoryEnabled(true);
        }
        Database::getEM()->flush();

        \XLite\Core\TopMessage::addInfo('PIN codes data have been successfully updated');
    }

    /**
     * Get pages sections
     *
     * @return array
     */
    public function getPages()
    {
        $pages = parent::getPages();
        if (!$this->isNew()) {
            $pages['pin_codes'] = static::t('PIN codes');
        }

        return $pages;
    }

    /**
     * Get pages templates
     *
     * @return array
     */
    protected function getPageTemplates()
    {
        $templates = parent::getPageTemplates();

        if (!$this->isNew()) {
            $templates += [
                'pin_codes' => 'modules/CDev/PINCodes/product/pin_codes.twig',
            ];
        }

        return $templates;
    }
}
