<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\Controller\Admin;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Auth;

/**
 * @Extender\Mixin
 */
class Order extends \XLite\Controller\Admin\Order
{
    /**
     * Get pages templates
     *
     * @return array
     */
    protected function getPageTemplates()
    {
        $tpls = parent::getPageTemplates();

        if ($this->getOrder() && $this->getOrder()->hasPinCodes()) {
            $tpls += [
                'pin_codes' => 'modules/CDev/PINCodes/order/pin_codes.twig',
            ];
        }

        return $tpls;
    }

    /**
     * Get pages sections
     *
     * @return array
     */
    public function getPages()
    {
        $pages = parent::getPages();
        if (
            $this->getOrder()
            && $this->getOrder()->hasPinCodes()
            && Auth::getInstance()->isPermissionAllowed('ROLE_MANAGE_ORDERS')
        ) {
            $pages['pin_codes'] = static::t('PIN codes');
        }

        return $pages;
    }

    /**
     * Get order items
     *
     * @return array
     */
    public function getOrderItems()
    {
        return $this->getOrder()->getItems();
    }

    /**
     * Remove temporary order
     *
     * @param \XLite\Model\Order $order Order
     *
     * @return void
     */
    protected function removeTemporaryOrder(\XLite\Model\Order $order)
    {
        foreach ($order->getItems() as $item) {
            foreach ($item->getPinCodes() as $pin) {
                \XLite\Core\Database::getEM()->remove($pin);
            }
        }

        parent::removeTemporaryOrder($order);
    }
}
