<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\API\Endpoint\ProductPINCode\Transformer;

use ApiPlatform\Core\DataTransformer\DataTransformerInterface;
use Exception;
use CDev\PINCodes\API\Endpoint\ProductPINCode\DTO\ProductPINCodeOutput as OutputDTO;
use CDev\PINCodes\Model\PinCode as Model;

class OutputTransformer implements DataTransformerInterface, OutputTransformerInterface
{
    /**
     * @param Model $object
     *
     * @throws Exception
     */
    public function transform($object, string $to, array $context = []): OutputDTO
    {
        $dto = new OutputDTO();
        $dto->id = $object->getId();
        $dto->code = $object->getCode();
        $dto->create_date = new \DateTimeImmutable('@' . $object->getCreateDate());
        $dto->is_sold = $object->getIsSold();
        $dto->is_blocked = $object->getIsBlocked();
        $dto->order_item_id = $object->getOrderItem() ? $object->getOrderItem()->getItemId() : null;

        return $dto;
    }

    public function supportsTransformation($data, string $to, array $context = []): bool
    {
        return $to === OutputDTO::class && $data instanceof Model;
    }
}
