<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\API\Endpoint\ProductPINCode\Transformer;

use CDev\PINCodes\API\Endpoint\ProductPINCode\DTO\ProductPINCodeInput as InputDTO;
use CDev\PINCodes\Model\PinCode as Model;

interface InputTransformerInterface
{
    public function transform(InputDTO $object, string $to, array $context = []): Model;

    public function supportsTransformation($data, string $to, array $context = []): bool;
}
