<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\API\Endpoint\ProductPINCode\InputRule\SubRule;

use ApiPlatform\Core\Exception\InvalidArgumentException;
use XLite\API\InputRule\SubRule\CheckUniqueField;
use XLite\Model\QueryBuilder\AQueryBuilder;

class CheckUniqueCode extends CheckUniqueField
{
    protected function buildQueryBuilder(object $inputDTO, array $context): AQueryBuilder
    {
        $productId = $this->detectProductId($inputDTO, $context);
        if (!$productId) {
            throw new InvalidArgumentException('Product ID is invalid');
        }

        return parent::buildQueryBuilder($inputDTO, $context)
            ->andWhere('o.product = :product_id')
            ->setParameter('product_id', $productId);
    }

    protected function detectProductId(object $inputDTO, array $context): ?int
    {
        if (preg_match('/products\/(\d+)\//S', $context['request_uri'], $match)) {
            return (int) $match[1];
        }

        return null;
    }
}
