<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\PINCodes\API\Endpoint\ProductPINCode\DataPersister;

use ApiPlatform\Core\DataPersister\ContextAwareDataPersisterInterface;
use ApiPlatform\Core\Exception\InvalidArgumentException;
use CDev\PINCodes\Model\PinCode as Model;

class DataPersister implements ContextAwareDataPersisterInterface
{
    protected ContextAwareDataPersisterInterface $inner;

    public function __construct(
        ContextAwareDataPersisterInterface $inner
    ) {
        $this->inner = $inner;
    }

    public function supports($data, array $context = []): bool
    {
        return $data instanceof Model;
    }

    /**
     * @param Model $data
     */
    public function persist($data, array $context = []): object
    {
        return $this->inner->persist($data, $context);
    }

    /**
     * @param Model $data
     */
    public function remove($data, array $context = []): void
    {
        if ($data->getIsSold()) {
            throw new InvalidArgumentException('Cannot delete sold PIN code');
        }

        $this->inner->remove($data, $context);
    }
}
