<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\MarketPrice\Transformer\XLite\Model\OrderItem\Logic\Entity\Storefront\Cart;

use XCart\Transformer\XLite\Model\OrderItem\Logic\Entity\Storefront\Cart\ItemInterface;
use XLite\Model\OrderItem as Source;
use XCart\Logic\Entity\Storefront\Cart\Item as Target;

class ItemDecorator implements ItemInterface
{
    public function __construct(
        private ItemInterface $inner
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        $target->setMarketPrice(
            $input->getProduct()->getMarketPrice()
        );

        return $target;
    }
}
