<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\GoogleAnalytics\LifetimeHook\Upgrade;

use CDev\GoogleAnalytics\Core\GA;
use XCart\Doctrine\FixtureLoader;
use XLite\Core\Database;
use XLite\Model\Config;

final class UpgradeTo551build0
{
    public function __construct(
        private FixtureLoader $fixtureLoader
    ) {
    }

    public function onUpgrade(): void
    {
        $needResetCodeVersionToUniversal = $this->needResetCodeVersionToUniversal();
        $needValues = !$this->hasMeasurementId();

        $this->loadYaml('upgrade', '5.5', '1.0');

        if ($needValues) {
            $this->loadYaml('values', '5.5', '1.0');
        }

        if ($needResetCodeVersionToUniversal) {
            $this->setCodeVersion(GA::CODE_VERSION_U);
        }
    }

    private function needResetCodeVersionToUniversal(): bool
    {
        $codeVersionOption = $this->getConfig()->findOneBy([
            'category' => 'CDev\GoogleAnalytics',
            'name'     => 'ga_code_version',
        ]);

        return $codeVersionOption && $codeVersionOption->getValue() !== GA::CODE_VERSION_4;
    }

    private function hasMeasurementId(): bool
    {
        $codeVersionOption = $this->getConfig()->findOneBy([
            'category' => 'CDev\GoogleAnalytics',
            'name'     => 'ga_measurement_id',
        ]);

        return (bool)$codeVersionOption;
    }

    private function setCodeVersion($value): void
    {
        $this->getConfig()->createOption(
            [
                'category' => 'CDev\GoogleAnalytics',
                'name'     => 'ga_code_version',
                'value'    => $value,
            ]
        );
    }

    private function getConfig(): \XLite\Model\Repo\Config
    {
        return Database::getRepo(Config::class);
    }

    private function loadYaml(string $name, string $major, string $minor): void
    {
        $this->fixtureLoader->loadYaml(LC_DIR_MODULES . "CDev/GoogleAnalytics/resources/hooks/upgrade/$major/$minor/$name.yaml");
    }
}
