/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * This is redundant comment to bypass headers check
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('googleAnalytics/eCommerceChangeItemEvent', ['googleAnalytics/base/eCommerceChangeItemEvent', 'js/underscore'], function (eCommerceChangeItemEventBase, _) {
      let eCommerceChangeItemEvent = eCommerceChangeItemEventBase.extend({

        registerAddToCart (event, data) {
          var currency = this.coreInstance.getSetting('currency')
          var gaProductData = data.gaProductData

          if (gaProductData) {
            if (!_.isUndefined(gaProductData.list)) {
              gaProductData.item_list_name = gaProductData.list
            }
            this.sendEvent('add_to_cart', {
              currency,
              items: [gaProductData]
            })
          }
        },

        registerAddsToCart (event, products) {
          let gaProducts = [];
          products.forEach((product) => {
            let gaProductData = product.gaProductData;
            if (gaProductData) {
              if (!_.isUndefined(gaProductData.list)) {
                gaProductData.item_list_name = gaProductData.list;
              }
              gaProducts.push(gaProductData);
            }
          }, products);

          if (!_.isEmpty(gaProducts)) {
            const currency = this.coreInstance.getSetting('currency');
            this.sendEvent('add_to_cart', {
              currency,
              items: gaProducts
            });
          }
        }

      });

      eCommerceChangeItemEvent.instance = new eCommerceChangeItemEvent();

      return eCommerceChangeItemEvent;
    }
);
