/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * This is redundant comment to bypass headers check
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

define('googleAnalytics/event', [ 'googleAnalytics/core', 'js/underscore' ], function(GACore, _) {
  return Object.extend({
    constructor: function () {
      this.coreInstance = GACore.instance

      this.initialize()
    },

    initialize() {
      jQuery().ready(_.bind(function () {
        this.executeIsBecomesAvailable(this.processReady, 10, 100);
      }, this));

      this.bindListeners()
    },

    bindListeners () {
      _.each(
        this.getListeners(),
        _.bind(
          function (handler, eventName) {
            xcart.bind(eventName, _.bind(function (event, params) {
              const callback = _.partial(handler, event, params)
              this.executeIsBecomesAvailable(callback, 10, 100);
            }, this))
          },
          this
        )
      )
    },

    executeIsBecomesAvailable(callback, count, delay) {
      if (!this.coreInstance.isAvailable()) {
        if (count > 0) {
          console.log('XCart-GA: waiting for GA', count, this)
          _.delay(_.partial(_.bind(this.executeIsBecomesAvailable, this), callback, count - 1, delay), delay);
        } else {
          console.warn('XCart-GA: GA not available', callback, this)
        }
        return;
      }

      callback.apply(this);
    },

    createFunctionWithTimeout (callback, args, opt_timeout) {
      var called = false

      function fn () {
        if (!called) {
          called = true
          callback(args)
        }
      }

      setTimeout(fn, opt_timeout || 500)
      return fn
    },

    getListeners () {
      return {}
    },

    processReady () {
    },

    sendPageView () {
      this.coreInstance.registerPageView()
    },

    sendEvent (name, label, value, namespace) {
      this.coreInstance.registerEvent(namespace || this.namespace, name, label, value)
    }
  });
});
