<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\GoSocial\Transformer\XLite\Model\Category\Logic\Entity\Storefront;

use XCart\Logic\Entity\Storefront\Category as Target;
use XCart\Transformer\XLite\Model\Category\Logic\Entity\Storefront\CategoryInterface;
use XLite\Model\Category as Source;

class CategoryDecorator implements CategoryInterface
{
    public function __construct(
        private CategoryInterface $inner,
    ) {
    }

    public function transform(Source $input): Target
    {
        return $this->inner->transform($input)
            ->setOgMetaTags($input->getOpenGraphMetaTags());
    }
}
