<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\GoSocial\API\Endpoint\Category\DTO;

use ApiPlatform\Core\Annotation\ApiProperty;
use Symfony\Component\Validator\Constraints as Assert;
use XCart\Extender\Mapping\Extender;
use XLite\API\Endpoint\Category\DTO\CategoryInput as CategoryInputOriginal;

/**
 * @Extender\Mixin
 */
class CategoryInput extends CategoryInputOriginal
{
    /**
     * @Assert\Choice(choices = {"A", "C"})
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={
     *             "type"="string",
     *             "enum"={"A", "C"},
     *             "example"="A"
     *         }
     *     }
     * )
     * @var string
     */
    public string $og_meta_tags_type = 'A';

    /**
     * @ApiProperty(
     *     attributes={
     *         "openapi_context"={"example"=""}
     *     }
     * )
     * @var string
     */
    public string $og_meta_tags = '';
}
