<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\FileAttachments\Logic\Action\Storefront\Product\GetOne;

use CDev\FileAttachments\Model\Product\Attachment as AttachmentModel;
use XCart\Bundle\LogicBundle\Action\ActionInterface;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Product\GetOne\Assembler\QueryBuilder\FindOneQueryBuilderAssemblerInterface;
use XCart\Logic\Action\Storefront\Product\GetOne\DTO\Response as GetOneProductResponse;
use XCart\Logic\Entity\Storefront\FileAttachment;

class ActionDecorator implements ActionInterface
{
    public function __construct(
        private ActionInterface $inner,
        private FindOneQueryBuilderAssemblerInterface $queryBuilderAssembler,
    ) {
    }

    public function run(RequestInterface $request): ResponseInterface
    {
        $response = $this->inner->run($request);

        if ($response instanceof GetOneProductResponse) {
            $qb      = $this->queryBuilderAssembler->assemble($request);
            $product = $qb->getQuery()->getOneOrNullResult();

            $profile = $request->getProfile();

            $availableAttachments = array_map(
                static function (AttachmentModel $attachment) {
                    return (new FileAttachment())
                        ->setUrl($attachment->getURL())
                        ->setTitle($attachment->getPublicTitle())
                        ->setDescription($attachment->getDescription());
                },
                $product->getFilteredAttachments($profile)->toArray()
            );

            $response->getPayload()->setAttachments($availableAttachments);
        }

        return $response;
    }
}
