<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\FileAttachments\Core;

use CDev\FileAttachments\Model\Product\Attachment;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend("CDev\FileAttachments")
 */
class Translation extends \XLite\Core\Translation
{
    public static function getModelsToExportTranslations(): array
    {
        return array_merge(
            parent::getModelsToExportTranslations(),
            [
                Attachment::class
            ]
        );
    }
}
