<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\FeaturedProducts\DataSource\Product\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\BooleanValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class FeaturedProductsApplier implements ApplierInterface
{
    /**
     * @param BooleanValue $filterValue
     */
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        return $queryBuilder
            ->andWhere('featuredProducts.category = :category')
            ->linkLeft('entity.featuredProducts')
            ->orderBy('featuredProducts.orderBy')
            ->setParameter('category', $filterValue->getValue());
    }
}
