<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\FeaturedProducts\API\Endpoint\Storefront\Product\Compact\GetFeaturedProducts\Assembler;

use Symfony\Component\HttpFoundation\RequestStack;
use XCart\Bundle\APIPlatformBridgeBundle\API\DataProvider\Collection\Assembler\RequestAssemblerInterface;
use XCart\Bundle\LogicBundle\DTO\Request\Filter\Value\IntegerValue;
use XCart\Bundle\LogicBundle\DTO\Request\RequestInterface;
use XCart\Bundle\LogicBundle\Enum\FilterStrategy\NumberFilterStrategyType;
use XCart\Logic\Action\Storefront\Product\GetList\DTO\Request;

class RequestAssembler implements RequestAssemblerInterface
{
    public function __construct(
        private RequestAssemblerInterface $internal,
        private RequestStack $requestStack
    ) {
    }

    public function assemble(string $resourceClass, string $operationName, array $context): RequestInterface
    {
        $categoryId = (int) ($this->requestStack->getCurrentRequest()->attributes->get('category_id') ?: 1);

        /** @var Request $request */
        $request = $this->internal->assemble($resourceClass, $operationName, $context);

        $request->getFilter()->setFeaturedCategoryId(
            (new IntegerValue())->setValue($categoryId)
                ->setStrategy(NumberFilterStrategyType::EXACT())
                ->setExclude(false)
        );

        return $request;
    }
}
