<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Egoods\EntityCallback;

use CDev\Egoods\Model\Product\Attachment\AttachmentHistoryPoint;
use Doctrine\Persistence\Event\LifecycleEventArgs;

final class AttachmentHistoryPointCallback
{
    public function prePersist(
        AttachmentHistoryPoint $attachmentHistoryPoint,
        LifecycleEventArgs $args
    ): void {
        $this->prepareBeforeSave($attachmentHistoryPoint);
    }

    public function preUpdate(
        AttachmentHistoryPoint $attachmentHistoryPoint,
        LifecycleEventArgs $args
    ): void {
        $this->prepareBeforeSave($attachmentHistoryPoint);
    }

    private function prepareBeforeSave(AttachmentHistoryPoint $attachmentHistoryPoint): void
    {
        if (!$attachmentHistoryPoint->getDate()) {
            $attachmentHistoryPoint->setDate(\XLite\Core\Converter::time());
        }
    }
}
