<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Egoods\EntityCallback;

use CDev\Egoods\Model\Product\Attachment\Storage;
use CDev\FileAttachments\Model\Product\Attachment;
use Doctrine\Persistence\Event\LifecycleEventArgs;

final class AttachmentCallback
{
    public function prePersist(Attachment $attachment, LifecycleEventArgs $args): void
    {
        if ($attachment->getStorage()->isPrivatePath()) {
            $attachment->setOldScope(true);
            $attachment->setPrivate(true);
            $attachment->getStorage()->setFileName(
                \substr(
                    $attachment->getStorage()->getFileName(),
                    0,
                    Storage::PRIVATE_SUFFIX_LENGTH * -1
                )
            );
        }
    }
}
