<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Coupons\Transformer\XLite\Model\Cart\Logic\Entity\Storefront;

use XCart\Transformer\CDev\Coupons\Model\UsedCoupon\Logic\Entity\Storefront\Cart\CouponInterface as CouponTransformer;
use XCart\Logic\Entity\Storefront\Cart as Target;
use XCart\Transformer\XLite\Model\Cart\Logic\Entity\Storefront\CartInterface;
use XLite\Model\Cart as Source;

class CartDecorator implements CartInterface
{
    public function __construct(
        private CartInterface $inner,
        private CouponTransformer $couponTransformer,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->inner->transform($input);

        $transformedCoupons = array_map(
            fn($coupon) => $this->couponTransformer->transform($coupon),
            $input->getUsedCoupons()->toArray()
        );

        $target->setCoupons($transformedCoupons);

        return $target;
    }
}
