<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Coupons\Transformer\Logic\Entity\Storefront\Cart\NewCoupon\CDev\Coupons\Model;

use ApiPlatform\Exception\InvalidArgumentException;
use CDev\Coupons\Core\CompatibilityException;
use CDev\Coupons\Model\Repo\Coupon as CouponRepository;
use CDev\Coupons\Model\Coupon as CouponModel;
use XCart\Transformer\Logic\Entity\Storefront\Cart\NewCoupon\CDev\Coupons\Model\UsedCouponInterface;
use CDev\Coupons\Model\UsedCoupon as Target;
use XCart\Logic\Entity\Storefront\Cart\NewCoupon as Source;
use XLite\Core\Translation;
use XLite\Model\Cart as CartModel;
use XLite\Model\Repo\Cart as CartRepository;

class UsedCouponDecorator implements UsedCouponInterface
{
    public function __construct(
        private UsedCouponInterface $inner,
        private CouponRepository $couponWriteRepository,
        private CartRepository $cartWriteRepository,
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = new Target();

        /** @var ?CouponModel $product */
        $coupon = $this->couponWriteRepository->findOneBy([
            'code' => $input->getCode()
        ]);

        if (!$coupon) {
            throw new InvalidArgumentException('Cannot found coupon');
        }

        /** @var CartModel $cart */
        $cart = $this->cartWriteRepository->find($input->getCartId());

        try {
            $coupon->checkUnique($cart);
            $coupon->checkCompatibility($cart);
        } catch (CompatibilityException $exception) {
            throw new InvalidArgumentException(Translation::lbl($exception->getMessage(), $exception->getParams()));
        }

        $target->setCoupon($coupon);
        $target->setOrder($cart);
        $cart->addUsedCoupons($target);

        return $target;
    }
}
