<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Coupons\Transformer\CDev\Coupons\Model\UsedCoupon\Logic\Entity\Storefront\Cart;

use XCart\Factory\Logic\Entity\Storefront\Cart\NewCouponInterface as Factory;
use XCart\Logic\Entity\Storefront\Cart\NewCoupon as Target;
use CDev\Coupons\Model\UsedCoupon as Source;
use XCart\Transformer\CDev\Coupons\Model\UsedCoupon\Logic\Entity\Storefront\Cart\NewCouponInterface;

class NewCouponDecorator implements NewCouponInterface
{
    public function __construct(
        private Factory $factory
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();

        $target->setId($input->getId());

        $target->setCode(
            $input->getCoupon()->getCode()
        );

        $target->setCartId(
            $input->getOrder()->getOrderId()
        );

        return $target;
    }
}
