<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Coupons\Transformer\CDev\Coupons\Model\UsedCoupon\Logic\Entity\Storefront\Cart;

use CDev\Coupons\Model\UsedCoupon as Source;
use XCart\Factory\Logic\Entity\Storefront\Cart\CouponInterface as Factory;
use XCart\Logic\Entity\Storefront\Cart\Coupon as Target;
use XCart\Transformer\CDev\Coupons\Model\UsedCoupon\Logic\Entity\Storefront\Cart\CouponInterface;

class CouponDecorator implements CouponInterface
{
    public function __construct(
        private CouponInterface $inner,
        private Factory $factory
    ) {
    }

    public function transform(Source $input): Target
    {
        $target = $this->factory->create();
        $coupon = $input->getCoupon();

        $target->setId($input->getId());
        $target->setType($coupon->getType());
        $target->setValue($coupon->getValue());
        $target->setCode($coupon->getCode());

        return $target;
    }
}
