<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace CDev\Coupons\Operation\Service\API;

use XCart\Operation\Service\API\GetPathsWithCartIdInterface;

final class GetPathsWithCartIdDecorator implements GetPathsWithCartIdInterface
{
    public function __construct(
        private GetPathsWithCartIdInterface $inner
    ) {
    }

    public function __invoke(): array
    {
        return array_merge(
            $this->inner->__invoke(),
            [
                '/api/storefront/carts/{cart_id}/coupons',
                '/api/storefront/carts/{cart_id}/coupons/{id}',
            ]
        );
    }
}
