<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Coupons\Logic\Action\Storefront\CartCoupon\DeleteOne\Assembler;

use CDev\Coupons\Model\Coupon as CouponModel;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\DeleteOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Response\ResponseInterface;
use XCart\Logic\Action\Storefront\Cart\Coupon\DeleteOne\DTO\Response as DeleteOneResponse;

class CalculationResponseAssemblerDecorator implements ResponseAssemblerInterface
{
    public function __construct(
        private ResponseAssemblerInterface $inner,
        private WriteRepositoryInterface $writeRepository,
    ) {
    }

    /**
     * @param CouponModel $entity
     *
     * @return DeleteOneResponse
     */
    public function assemble(EntityInterface $entity): ResponseInterface
    {
        $entity->getOrder()->updateOrder();

        $this->writeRepository->updateEntity($entity->getOrder());

        return $this->inner->assemble($entity);
    }
}
