<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Coupons\Logic\Action\Storefront\CartCoupon\CreateOne\Assembler;

use CDev\Coupons\Model\Coupon as CouponModel;
use XCart\Bundle\DoctrineBridgeBundle\Assembler\GetOne\Response\ResponseAssemblerInterface;
use XCart\Bundle\DoctrineBridgeBundle\Entity\EntityInterface;
use XCart\Bundle\DoctrineBridgeBundle\Repository\WriteRepositoryInterface;
use XCart\Bundle\LogicBundle\DTO\Response\PayloadOwnerResponseInterface;
use XCart\Logic\Action\Storefront\Cart\Coupon\CreateOne\DTO\Response as CreateOneResponse;

class CalculationResponseAssemblerDecorator implements ResponseAssemblerInterface
{
    public function __construct(
        private ResponseAssemblerInterface $inner,
        private WriteRepositoryInterface $writeRepository,
    ) {
    }

    /**
     * @param CouponModel $entity
     *
     * @return CreateOneResponse
     */
    public function assemble(EntityInterface $entity): PayloadOwnerResponseInterface
    {
        $entity->getOrder()->updateOrder();

        $this->writeRepository->updateEntity($entity->getOrder());

        return $this->inner->assemble($entity);
    }
}
