<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Coupons\EntityCallback;

use CDev\Coupons\Model\UsedCoupon;
use Doctrine\Persistence\Event\LifecycleEventArgs;

final class UsedCouponCallback
{
    public function preRemove(UsedCoupon $usedCoupon, LifecycleEventArgs $args): void
    {
        if ($usedCoupon->getCoupon() && $usedCoupon->getCoupon()->getUsedCoupons()) {
            $usedCoupon->getCoupon()->getUsedCoupons()->removeElement($usedCoupon);
        }

        if ($usedCoupon->getOrder() && $usedCoupon->getOrder()->getUsedCoupons()) {
            $usedCoupon->getOrder()->getUsedCoupons()->removeElement($usedCoupon);
        }
    }
}
