<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Coupons\API\Endpoint\Storefront\CartCoupon\SubIriConverter;

use Symfony\Component\Routing\RouterInterface;
use XCart\API\Entity\Storefront\Cart\Coupon as Entity;
use XCart\Framework\ApiPlatform\Core\Bridge\Symfony\Routing\SubIriConverter\SubIriFromItemConverterInterface;
use CDev\Coupons\Model\UsedCoupon as UsedCouponModel;
use CDev\Coupons\Model\Repo\UsedCoupon as UsedCouponRepository;

class SubIriConverter implements SubIriFromItemConverterInterface
{
    public function __construct(
        private RouterInterface $router,
        private UsedCouponRepository $usedCouponReadRepository,
    ) {
    }

    public function supportIriFromItem(object $item, int $referenceType): bool
    {
        return $item instanceof Entity;
    }

    /**
     * @param Entity $item
     */
    public function getIriFromItem(object $item, int $referenceType): string
    {
        /** @var ?UsedCouponModel $usedCoupon */
        $usedCoupon = $this->usedCouponReadRepository->findOneBy([
            'code' => $item->getCode(),
        ]);

        return $this->router->generate(
            'api_cart coupons_get_item',
            [
                'cart_id' => $usedCoupon->getOrder()->getPublicId(),
                'id'      => $usedCoupon->getId(),
            ],
            $referenceType
        );
    }
}
