<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Bestsellers\Logic\Action\Storefront\Product\GetList\Resolver;

use CDev\Bestsellers\DataSource\Product\Applier\BestsellersApplier;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\BooleanValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Resolver\FilterApplierResolverInterface;

class BestsellersFilterApplierResolverDecorator implements FilterApplierResolverInterface
{
    public function __construct(
        private FilterApplierResolverInterface $inner
    ) {
    }

    /**
     * @param BooleanValue $value
     */
    public function resolve(string $property, FilterValueInterface $value): ?ApplierInterface
    {
        if ($property === 'bestsellers') {
            return new BestsellersApplier();
        }

        return $this->inner->resolve($property, $value);
    }
}
