<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Bestsellers\DataSource\Product\Applier;

use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\BooleanValue;
use XCart\Bundle\DoctrineBridgeBundle\DTO\Filter\Value\FilterValueInterface;
use XCart\Bundle\DoctrineBridgeBundle\Enricher\GetList\Filter\Applier\ApplierInterface;
use XCart\Bundle\DoctrineBridgeBundle\QueryBuilder\QueryBuilderInterface;

class BestsellersApplier implements ApplierInterface
{
    /**
     * @param BooleanValue $filterValue
     */
    public function apply(string $name, FilterValueInterface $filterValue, QueryBuilderInterface $queryBuilder): QueryBuilderInterface
    {
        return $queryBuilder->andWhere(
            $filterValue->getValue()
                ? 'entity.sales > 0'
                : 'entity.sales = 0'
        );
    }
}
