<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\Bestsellers;

use CDev\Bestsellers\DependencyInjection\Compiler\AddProductFilterByBestsellersFieldPass;
use Symfony\Component\DependencyInjection\Compiler\PassConfig;
use Symfony\Component\DependencyInjection\ContainerBuilder;
use Symfony\Component\HttpKernel\Bundle\Bundle;

class BestsellersBundle extends Bundle
{
    public function build(ContainerBuilder $container): void
    {
        parent::build($container);

        $container->addCompilerPass(new AddProductFilterByBestsellersFieldPass(), PassConfig::TYPE_BEFORE_OPTIMIZATION, 710);
    }
}
