<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace CDev\AustraliaPost\View\FormField;

use CDev\AustraliaPost\Model\Shipping\Processor\AustraliaPost;

/**
 * Package box type selector for settings page
 */
class PackageBoxType extends \XLite\View\FormField\Select\Regular
{
    /**
     * Get default options for selector
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        $list = [];

        /** @var \XLite\Model\Shipping\Method $method */
        $method = AustraliaPost::getMethod();
        $processor = $method->getProcessorObject();
        $packageBoxTypeOptions = $processor->getPackageBoxTypeOptions();

        foreach ($packageBoxTypeOptions as $option) {
            $list[$option['code']] = $option['name'];
        }

        return $list;
    }
}
