<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View\Settings;

use Amazon\PayWithAmazon\Main;
use XCart\Extender\Mapping\ListChild;

/**
 * @ListChild (list="payment_status.after.PayWithAmazon", zone="admin", weight="200")
 */
class SignUpLink extends \XLite\View\AView
{
    /**
     * Check if widget is visible
     *
     * @return boolean
     */
    protected function isVisible()
    {
        return parent::isVisible()
            && !Main::getMethod()->isConfigured()
            && Main::getMethod()->getSetting('region');
    }

    /**
     * @return array
     */
    public function getCSSFiles()
    {
        $list   = parent::getCSSFiles();
        $list[] = 'modules/Amazon/PayWithAmazon/settings/style.css';

        return $list;
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/Amazon/PayWithAmazon/payment_status.twig';
    }
}
