<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View\Product;

/**
 * Class ProductCheckoutButton
 */
class ProductCheckoutButton extends \XLite\View\Product\Details\Customer\Widget
{
    protected function isVisible()
    {
        $method = \Amazon\PayWithAmazon\Main::getMethod();
        $disabled = $this->getProduct() ? !$this->getProduct()->getAmazonPaymentEnabled() : true;

        return parent::isVisible()
            && $method->isEnabled()
            && $method->getSetting('product_button')
            && !$disabled;
    }

    /**
     * Return the specific widget service name to make it visible as specific CSS class
     *
     * @return null|string
     */
    public function getFingerprint()
    {
        return 'widget-fingerprint-product-checkout-pwa-button';
    }

    /**
     * Return directory contains the template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/Amazon/PayWithAmazon/product/details/product_checkout_button.twig';
    }
}
