<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View\Model\Address;

use Amazon\PayWithAmazon\Main;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Address extends \XLite\View\Model\Address\Address
{
    public function getAddressSchema()
    {
        $result = parent::getAddressSchema();
        $addressId = $this->getAddressId();

        if (Main::isConfigured()) {
            foreach ($result as $key => $data) {
                if ($addressId . '_' . 'phone' == $key) {
                    $result[$key][static::SCHEMA_REQUIRED] = true;
                }
            }
        }

        return $result;
    }
}
