<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View;

use XCart\Extender\Mapping\Extender;
use Amazon\PayWithAmazon\Main;
use XLite\Model\Cart;

/**
 * @Extender\Mixin
 */
class Header extends \XLite\View\Header
{
    /**
     * @return array
     */
    protected function getAmazonConfig()
    {
        $result = [];
        $method = Main::getMethod();
        foreach ($method->getSettings() as $setting) {
            $result[$setting->getName()] = $setting->getValue();
        }

        $result['locale'] = Main::getLocaleCode();

        /** @var Cart $cart */
        $cart = $this->getCart();
        $transaction = $cart->getFirstOpenPaymentTransaction();
        $sessionId = $transaction ? $transaction->getDataCell('checkoutSessionId') : null;
        $result['sessionId'] = $sessionId ? $sessionId->getValue() : null;

        $result['isPayOnly'] = !$cart->isEmpty() && !$cart->isShippable();

        return $result;
    }

    /**
     * @return boolean
     */
    protected function isAmazonConfigured()
    {
        return Main::isConfigured();
    }

    /**
     * Returns string 'true' if test mode enabled, 'false' otherwise
     *
     * @return string
     */
    protected function isSandboxMode()
    {
        $method    = Main::getMethod();
        $processor = Main::getProcessor();

        return $processor->isTestMode($method) ? 'true' : 'false';
    }
}
