<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View\FormModel\Product;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Info extends \XLite\View\FormModel\Product\Info
{
    /**
     * @return array
     */
    protected function defineFields()
    {
        $schema = parent::defineFields();

        if (\Amazon\PayWithAmazon\Main::getMethod()->isEnabled()) {
            $schema['marketing']['amazonPaymentEnabled'] = [
                'label'     => static::t('Amazon payment available'),
                'type'      => 'XLite\View\FormModel\Type\SwitcherType',
                'position'  => 700,
                'show_when' => [
                    static::SECTION_DEFAULT => [
                        'available_for_sale' => '1',
                    ],
                ],
            ];
        }

        return $schema;
    }
}
