<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View\FormField\Select;

/**
 * Region selector
 */
class Region extends \XLite\View\FormField\Select\Regular
{
    /**
     * @var array
     */
    protected static $regions = [
        'us' => 'USD',
        'uk' => 'GBP',
        'de' => 'EUR',
    ];

    /**
     * @param $region
     *
     * @return string
     */
    public static function getCurrencyByRegion($region)
    {
        return static::$regions[$region] ?? '';
    }

    /**
     * @param $currency
     *
     * @return string
     */
    public static function getRegionByCurrency($currency)
    {
        $currencies = array_flip(static::$regions);

        return $currencies[$currency] ?? '';
    }

    /**
     * Get default options
     *
     * @return array
     */
    protected function getDefaultOptions()
    {
        return [
            ''    => 'Select',
            'USD' => 'United States (USD)',
            'GBP' => 'United Kingdom (GBP)',
            'EUR' => 'Germany (EUR)'
        ];
    }
}
