<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace Amazon\PayWithAmazon\View;

use Amazon\PayWithAmazon\Main;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class CommonResources extends \XLite\View\CommonResources
{
    /**
     * @param boolean|null $adminZone
     *
     * @return array
     */
    protected function getThemeFiles($adminZone = null)
    {
        $list = parent::getThemeFiles($adminZone);

        if (!($adminZone ?? \XLite::isAdminZone())) {
            if (Main::isConfigured()) {
                $list[static::RESOURCE_JS][] = [
                    'url'   => Main::getProcessor()->getJsSdkUrl(Main::getMethod()),
                    'async' => true,
                ];

                $list[static::RESOURCE_JS][]  = 'modules/Amazon/PayWithAmazon/func.js';
                $list[static::RESOURCE_CSS][] = 'modules/Amazon/PayWithAmazon/checkout_button/style.css';
            }
        }

        return $list;
    }
}
